#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 dirLight : register (c14);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
#ifdef USEFOG
   half   Fog   : FOG;
#endif   
#if OMNI == 1 || SPOT == 1   
   half4  Omni  : COLOR0;
#else
   half4  Diff  : COLOR0;
#endif   
   float3 Light : COLOR1;
   float2 Tex0  : TEXCOORD0; // base
   float2 Tex1  : TEXCOORD1; // specular map
   float2 Bump  : TEXCOORD2; // bump map
   float3 Half  : TEXCOORD3;
};

#if OMNI == 1
VS_OUTPUT vs11_blinnBumpSpecMapOmniT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1, float2 inBump : TEXCOORD2)
#elif SPOT == 1
VS_OUTPUT vs11_blinnBumpSpecMapSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1, float2 inBump : TEXCOORD2)
#else
VS_OUTPUT vs11_blinnBumpSpecMapT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD1, float2 inBump : TEXCOORD2)
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);

  float3 worldPos = mul (worldMatrix, inPos);
  float3 eyeVec = (worldEye.xyz + worldPos.xyz);

  float3 worldS;
  float3 worldT;
  float3 worldSxT;
  worldS.xyz = mul (worldMatrix, inTangent.xyz);
  worldT.xyz = mul (worldMatrix, inBiNorm.xyz);
  worldSxT.xyz = mul (worldMatrix, inNorm.xyz);
  
  float3 localLight;
  localLight.x = dot (dirLight.xyz, worldS.xyz);
  localLight.y = dot (dirLight.xyz, worldT.xyz);
  localLight.z = dot (dirLight.xyz, worldSxT.xyz);
  Out.Light = ((localLight) * 0.5) + 0.5;
  
  float3 halfway = normalize (dirLight.xyz - normalize (eyeVec.xyz)); 
  Out.Half.x = dot (halfway.xyz, worldS.xyz);
  Out.Half.y = dot (halfway.xyz, worldT.xyz);
  Out.Half.z = dot (halfway.xyz, worldSxT.xyz);

#ifdef USEFOG
  // compute fog
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   

#if OMNI == 1  

  // Compute omnilights
  half3 omni = {0.0, 0.0, 0.0};
  Out.Omni.a = inColor.a;

  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  for (int i=0; i<6; i++)
  {
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
    {
      //if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
      float intens = max (0.0, dot (worldNorm, normalize (omniToVert)));
      omni.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
    }    
  }
  Out.Omni.rgb = omni * 0.5;

#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,1);
  float3 worldNorm = mul (worldMatrix, inNorm);
  
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize(spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( mag * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Omni = spotColor;

#else
  Out.Diff = inColor;
#endif

  // Propagate color and texture coordinates:
  Out.Tex0 = inTex;
  Out.Tex1 = inSpec;
  Out.Bump = inBump;

  return (Out);
}

